/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.group;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import oracle.ias.cache.group.GroupCommunication;
import oracle.ias.cache.group.Job;

public class AsyncQueue {
    List queue = Collections.synchronizedList(new LinkedList());

    synchronized Job dequeue() {
        Job job = null;
        if (this.queue.size() != 0) {
            try {
                job = (Job)this.queue.remove(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return job;
    }

    synchronized void enqueue(Job job) {
        this.queue.add(job);
        this.wakeup();
    }

    synchronized void sleep(int n) {
        try {
            if (this.queue.size() == 0) {
                this.wait(n);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    synchronized void wakeup() {
        this.notifyAll();
    }

    synchronized void dump() {
        GroupCommunication.log("--- AsyncQueue Dump---");
        ListIterator listIterator = this.queue.listIterator();
        while (listIterator.hasNext()) {
            Job job = (Job)listIterator.next();
            GroupCommunication.log(job.toString());
        }
    }
}

